// specular.vs
//
// Standardowe przeksztacenie wierzchokw,
// wiato rozproszone oraz refleksy wyliczone na podstawie
// pojedynczego rda wiata biaego

uniform vec3 lightPos0;

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    vec3 N = normalize(gl_NormalMatrix * gl_Normal);
    vec4 V = gl_ModelViewMatrix * gl_Vertex;
    vec3 L = normalize(lightPos0 - V.xyz);
    vec3 H = normalize(L + vec3(0.0, 0.0, 1.0));
    const float specularExp = 128.0;

    // wyliczenie owietlenia wiatem rozproszonym
    float NdotL = dot(N, L);
    vec4 diffuse = gl_Color * vec4(max(0.0, NdotL));

    // wyliczenie refleksu wietlnego
    float NdotH = dot(N, H);
    vec4 specular = vec4(pow(max(0.0, NdotH), specularExp));

    // dodajemy skadowe owietlenia
    gl_FrontColor = diffuse + specular;
}

